#!/bin/bash

#script fgradBM.sh
#	- extracts \xi and free energy gradients for series of 7 integration points  
#	and plots the result on standard output. The script assumes that calculations for 
#	all integration points are performed in a separate subdirectory named 1-7. 

drct=$(pwd)

#c equilibration period
equil=500

j=-1

for i in 1 2 3 4 5 6 7
do
  if test -d  $i
  then
    let j+=1
    cd $i

    if test -f report.all
    then
      rm report.all
    fi


    #c collect the BM output from all REPORT files
    k=1
    while [ $k -le 100 ]
    do
      if test -f report.$k
      then
        grep b_m report.$k >>report.all
      fi
      let k=k+1
    done

    #c identify the value of \xi
    x1=$(grep cc report.1|head -1|awk '{print $3}')
    
    nlines=$(wc -l report.all|awk '{print $1}')
    let prod=nlines-equil

    zet=$(grep b_m report.all|tail -$prod |awk 'BEGIN {a=0.} {a+=$3} END {print a/NR}')

    g1=$(grep b_m report.all|tail -$prod |awk 'BEGIN {a=0.} {a+=$5} END {print a/NR/"'${zet}'"}')
   
    echo $x1 $g1

    cd $drct
  
  fi

done

