import h5py
import numpy as np
import matplotlib.pyplot as plt 

h5file = h5py.File('vaspout.h5','r')

lat = h5file['input/poscar/lattice_vectors'][:]
eig = h5file['results/phonons/frequencies'][:]
kpt = h5file['results/phonons/qpoint_coords'][:]

def red_car(red,lat):
    return np.array([coord[0]*lat[0]+coord[1]*lat[1]+coord[2]*lat[2] for coord in red])

def car_red(car,lat):
    return np.array([np.linalg.solve(np.array(lat).T,coord) for coord in car])

def rec_lat(lat):
    v = vol_lat(lat)
    a1,a2,a3 = np.array(lat)
    b1 = np.cross(a2,a3)/v
    b2 = np.cross(a3,a1)/v
    b3 = np.cross(a1,a2)/v
    return np.array([b1,b2,b3])

def vol_lat(lat):
    a1,a2,a3 = np.array(lat)
    return np.dot(a1,np.cross(a2,a3))

#print kpoints
with open('kpoints','w') as f:
    for k in kpt:
        f.write(('%12.8lf '*3+'\n')%tuple(k))

dist = 0 
dists = [0] 
rlat = rec_lat(lat)
kpt_car = red_car(kpt,rlat)
for ik in range(len(kpt_car)-1):
    dist += np.linalg.norm(kpt_car[ik]-kpt_car[ik+1])
    dists.append(dist)

#plot eigen
nkpoints,nbands = eig.shape
for nb in range(nbands):
    y = eig[:,nb]
    x = dists
    plt.plot(x,y,c='b')

#plt.xlim(0,2)
#plt.ylim(0,8)
plt.savefig("plot.png")
