from hex import plot_commensurate
from math import sqrt
import matplotlib.pyplot as plt

#hexagonal lattice
lat = [[   1.0,      0.0],
       [-1.0/2,sqrt(3)/2]]
    
fig,axes = plt.subplots(2,3)
for ax,N in zip(axes.flatten(),[1,2,3,4,5,6]):
    plot_commensurate(ax,lat,N)
    ax.set_title(f"{N}x{N}")
fig.set_size_inches(10, 10)
fig.savefig("images/hex_lat.png")