#!/bin/bash

# ensure that this sequence of MD runs is reproducible
cp POSCAR.init POSCAR
cp INCAR.init INCAR
rseed="RANDOM_SEED =         311137787                0                0"
echo $rseed >> INCAR

backupfiles="REPORT vaspout.h5"

for i in 1 2 3 4 5 6 7 8 9 10
do

  # start vasp
  mpirun -np 3 vasp_gam

  # ensure that this sequence of MD runs is reproducible
  rseed=$(grep RANDOM_SEED REPORT |tail -1)
  cp INCAR.init INCAR
  echo $rseed >> INCAR

  # use the last configuration generated in the previous
  # run as initial configuration for the next run
  cp CONTCAR POSCAR

  # backup some important files
  mkdir run$i
  for f in $backupfiles
  do
      cp $f run$i/.
  done
done
