rm -f zpr_vs_conf.dat

nions=`grep NIONS OUTCAR.pristine | awk '{print $12}'`
occ_pristine=`grep -A $((nions * 2)) " band energies" OUTCAR.pristine | tail -3 | awk '{sum += $2} END {print sum/NR}'`
con_pristine=`grep -A $((nions * 2 + 6)) " band energies" OUTCAR.pristine | tail -6 | awk '{sum += $2} END {print sum/NR}'`
gap_pristine=$(awk -v con="$con_pristine" -v occ="$occ_pristine" 'BEGIN {print con - occ}')
occ_oneshot=`grep -A $((nions * 2)) " band energies" OUTCAR.oneshot_T0 | tail -3 | awk '{sum += $2} END {print sum/NR}'`
con_oneshot=`grep -A $((nions * 2 + 6)) " band energies" OUTCAR.oneshot_T0 | tail -6 | awk '{sum += $2} END {print sum/NR}'`
gap_oneshot=$(awk -v con="$con_oneshot" -v occ="$occ_oneshot" 'BEGIN {print con - occ}')
gap_diff=`awk -v gpris=$gap_pristine -v gonesh=$gap_oneshot 'BEGIN{print gonesh-gpris}'`
echo $gap_diff >> oneshot.dat
   
for i in {1..30}
do
   nions=`grep NIONS OUTCAR.${i} | awk '{print $12}'`
   occ_mc=`grep -A $((nions * 2)) " band energies" OUTCAR.${i} | tail -3 | awk '{sum += $2} END {print sum/NR}'`
   con_mc=`grep -A $((nions * 2 + 6)) " band energies" OUTCAR.${i} | tail -6 | awk '{sum += $2} END {print sum/NR}'`
   gap_mc=$(awk -v con="$con_mc" -v occ="$occ_mc" 'BEGIN {print con - occ}')
   gap_diff_mc=`awk -v gpris=$gap_pristine -v gonesh=$gap_mc 'BEGIN{print gonesh-gpris}'`
   echo $gap_diff_mc >> zpr_vs_conf.dat
done

awk 'BEGIN{n=0;sum=0.0} {n=n+1;sum=sum+$1; 
			if (n==10){print "average ZPR for 10 structures",sum/n}; 
			if (n==15){print "average ZPR for 15 structures",sum/n}; 
			if (n==20){print "average ZPR for 20 structures",sum/n}; 
			if (n==25){print "average ZPR for 25 structures",sum/n}; 
			if (n==30){print "average ZPR for 30 structures",sum/n};}' zpr_vs_conf.dat

awk -v go=$gap_diff 'BEGIN{print "ZPR oneshot:",go}'
