#!/bin/bash

VASP="mpirun -np 4 vasp_std"

for count in {1..8}
do 
   echo $count
   mkdir -p "$count"
   cp POSCAR POTCAR $count/
   sed 4q KPOINTS > $count/KPOINTS
   shift=$(sed -n "$count"p POINTS)
   echo $shift >> $count/KPOINTS
   weight=$(echo $shift | awk '{print $NF}')

   cd "$count"
   cp ../INCAR.DFT ./INCAR
   $VASP 

   cp ../INCAR.DDH ./INCAR
   $VASP
  
   cp ../INCAR.TDHF ./INCAR
   $VASP
   ../extract_optics.sh vasprun.xml 
   awk -v w=$weight '{print $1,$2*w}' optics.dat > optics_weighted.dat

   cd ..
done

paste {1..8}/optics_weighted.dat | awk '{print $1,($2+$4+$6+$8+$10+$12+$14+$16)/64};' > optics.dat
